Before running the code, you will have to update the path variable in Line 8 in:

> utils.datasets.paths.py

Cifar10/100 will be downloaded automatically, but you will need to manually place the 80 Million Tiny Images .bin file in a subdirectory:

> 80M Tiny Images 

Similarly, LSUN has to be placed in a subidrectory:

> LSUN_scenes

If your subdirectories are named differently, you can simply edit the paths.py 

To train the 4k labeled + 1M Tiny Images base model run the code:

> python ssl_cifar10.py --gpu 0 --net wideresnet28x2 --bs 128 --train_type CEDA --augm autoaugment_cutout --epochs 5000 --lr 0.1 --od_dataset tinyImages_subset --cifar_subset 4000 --unlabeled_samples 1_000_000

The code will output a model name that should look like:

> CEDA_02-03-2021_17:33:05

You can also get the name from the subfolder in:

> CIFAR10Models/WideResNet28x2/

Alternative you open a tensorboard instance and look up the model name there. The log folder is: 

> Cifar10Logs/WideResNet28x2/

After training of the base model is finished, you can start the actual ODST iterations:

> python ssl_cifar10_complete_run.py --gpu 0 --net wideresnet28x2 --bs 128 --train_type CEDATargetedKL --augm autoaugment_cutout --epochs 1000 --lr 0.1 --CEDA_label_smoothing 0.5 --od_dataset tinyImages_subset --cifar_subset 4000 --unlabeled_samples 1_000_000 --semi_ratio 0  --start_samples 2_000 --additional_samples 2_000 --od_validation_samples 2_000 --teacher CHANGE_THIS --threshold 0.980 --od_threshold None --od_validation_set cifar100

Note that you have to replace the --teacher argument with the name of your first teacher model, eg CEDA_02-03-2021_17:33:05
This file will run 5 iterations of ODST self training, including labeling the unlabeled pool and estimating thresholds.
If you want to run the ODST+ version instead, simply replace --od_threshold None with --od_threshold same

If you instead want to run the 10M version use: --unlabeled_samples 10_000_000
Note that you will have to train a new base teacher model for this too!
For LSUN, simply use: --od_dataset lsun_subset